/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.ast;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.ast.BlankLine;
import icyllis.flexmark.util.ast.BlankLineContainer;
import icyllis.flexmark.util.ast.DescendantNodeIterable;
import icyllis.flexmark.util.ast.Document;
import icyllis.flexmark.util.ast.NodeIterable;
import icyllis.flexmark.util.ast.NodeIterator;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import icyllis.flexmark.util.misc.Pair;
import icyllis.flexmark.util.misc.Utils;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Range;
import icyllis.flexmark.util.sequence.SegmentedSequence;
import icyllis.flexmark.util.sequence.builder.SequenceBuilder;
import icyllis.flexmark.util.visitor.AstNode;
import java.util.Arrays;

public abstract class Node {
    public static final BasedSequence[] EMPTY_SEGMENTS = BasedSequence.EMPTY_ARRAY;
    public static final String SPLICE = " \u2026 ";
    public static final AstNode<Node> AST_ADAPTER = new AstNode<Node>(){

        @Override
        @Nullable
        public Node getFirstChild(@NotNull Node node) {
            return node.firstChild;
        }

        @Override
        @Nullable
        public Node getNext(@NotNull Node node) {
            return node.next;
        }
    };
    @Nullable
    private Node parent = null;
    @Nullable
    Node firstChild = null;
    @Nullable
    private Node lastChild = null;
    @Nullable
    private Node prev = null;
    @Nullable
    Node next = null;
    @NotNull
    private BasedSequence chars = BasedSequence.NULL;

    public Node() {
    }

    public Node(@NotNull BasedSequence chars) {
        this.chars = chars;
    }

    public int getStartOffset() {
        return this.chars.getStartOffset();
    }

    public int getEndOffset() {
        return this.chars.getEndOffset();
    }

    public int getTextLength() {
        return this.chars.length();
    }

    public BasedSequence getBaseSequence() {
        return this.chars.getBaseSequence();
    }

    public Range getSourceRange() {
        return this.chars.getSourceRange();
    }

    public BasedSequence baseSubSequence(int startIndex, int endIndex) {
        return this.chars.baseSubSequence(startIndex, endIndex);
    }

    public BasedSequence baseSubSequence(int startIndex) {
        return this.chars.baseSubSequence(startIndex);
    }

    public BasedSequence getEmptyPrefix() {
        return this.chars.getEmptyPrefix();
    }

    public BasedSequence getEmptySuffix() {
        return this.chars.getEmptySuffix();
    }

    public int getStartOfLine() {
        return this.chars.baseStartOfLine();
    }

    public int getEndOfLine() {
        return this.chars.baseEndOfLine();
    }

    public int startOfLine(int index) {
        return this.chars.baseStartOfLine(index);
    }

    public int endOfLine(int index) {
        return this.chars.baseEndOfLine(index);
    }

    public Pair<Integer, Integer> lineColumnAtIndex(int index) {
        return this.chars.baseLineColumnAtIndex(index);
    }

    public Pair<Integer, Integer> lineColumnAtStart() {
        return this.chars.baseLineColumnAtStart();
    }

    public Pair<Integer, Integer> getLineColumnAtEnd() {
        return this.chars.baseLineColumnAtEnd();
    }

    @Nullable
    public Node getAncestorOfType(Class<?> ... classes) {
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            for (Class<?> nodeType : classes) {
                if (!nodeType.isInstance(parent)) continue;
                return parent;
            }
        }
        return null;
    }

    public int countAncestorsOfType(Class<?> ... classes) {
        int count = 0;
        block0: for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            for (Class<?> nodeType : classes) {
                if (!nodeType.isInstance(parent)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    public int countDirectAncestorsOfType(@Nullable Class<?> skip, Class<?> ... classes) {
        int count = 0;
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            boolean hadMatch = false;
            for (Class<?> nodeType : classes) {
                if (nodeType.isInstance(parent)) {
                    ++count;
                    hadMatch = true;
                    break;
                }
                if (skip == null || !skip.isInstance(parent)) continue;
                hadMatch = true;
                break;
            }
            if (!hadMatch) break;
        }
        return count;
    }

    @Nullable
    public Node getOldestAncestorOfTypeAfter(@NotNull Class<?> ancestor, @NotNull Class<?> after) {
        Node oldestAncestor = null;
        for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (ancestor.isInstance(parent)) {
                oldestAncestor = parent;
                continue;
            }
            if (after.isInstance(parent)) break;
        }
        return oldestAncestor;
    }

    @Nullable
    public Node getChildOfType(Class<?> ... classes) {
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            for (Class<?> nodeType : classes) {
                if (!nodeType.isInstance(child)) continue;
                return child;
            }
        }
        return null;
    }

    public static int getNodeOfTypeIndex(@NotNull Node node, Class<?> ... classes) {
        int i = 0;
        for (Class<?> nodeType : classes) {
            if (nodeType.isInstance(node)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isOrDescendantOfType(Class<?> ... classes) {
        for (Node node = this; node != null; node = node.getParent()) {
            if (node.getNodeOfTypeIndex(classes) == -1) continue;
            return true;
        }
        return false;
    }

    public int getNodeOfTypeIndex(Class<?> ... classes) {
        return Node.getNodeOfTypeIndex(this, classes);
    }

    @Nullable
    public Node getLastBlankLineChild() {
        return null;
    }

    @NotNull
    public ReversiblePeekingIterable<Node> getChildren() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new NodeIterable(this.firstChild, this.lastChild, false);
    }

    @NotNull
    public ReversiblePeekingIterable<Node> getReversedChildren() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new NodeIterable(this.firstChild, this.lastChild, true);
    }

    @NotNull
    public ReversiblePeekingIterable<Node> getDescendants() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new DescendantNodeIterable(this.getChildren());
    }

    @NotNull
    public ReversiblePeekingIterable<Node> getReversedDescendants() {
        if (this.firstChild == null) {
            return NodeIterable.EMPTY;
        }
        return new DescendantNodeIterable(this.getReversedChildren());
    }

    @NotNull
    public ReversiblePeekingIterator<Node> getChildIterator() {
        if (this.firstChild == null) {
            return NodeIterator.EMPTY;
        }
        return new NodeIterator(this.firstChild, this.lastChild, false);
    }

    @NotNull
    public ReversiblePeekingIterator<Node> getReversedChildIterator() {
        if (this.firstChild == null) {
            return NodeIterator.EMPTY;
        }
        return new NodeIterator(this.firstChild, this.lastChild, true);
    }

    @NotNull
    public BasedSequence getChars() {
        return this.chars;
    }

    public void removeChildren() {
        Node child = this.firstChild;
        while (child != null) {
            Node nextChild = child.getNext();
            child.unlink();
            child = nextChild;
        }
    }

    public boolean hasChildren() {
        return this.firstChild != null;
    }

    public boolean hasOrMoreChildren(int childCount) {
        if (this.firstChild != null) {
            int count = 0;
            for (Node child : this.getChildren()) {
                if (++count < childCount) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Document getDocument() {
        Node node;
        for (node = this; node != null && !(node instanceof Document); node = node.getParent()) {
        }
        assert (node != null) : "Node should always have Document ancestor";
        return (Document)node;
    }

    public void setChars(@NotNull BasedSequence chars) {
        this.chars = chars;
    }

    @Nullable
    public Node getNext() {
        return this.next;
    }

    @NotNull
    public Node getLastInChain() {
        Node lastNode = this;
        while (this.getClass().isInstance(lastNode.getNext())) {
            lastNode = lastNode.getNext();
        }
        return lastNode;
    }

    @Nullable
    public Node getPrevious() {
        return this.prev;
    }

    public void extractToFirstInChain(@NotNull Node node) {
        this.getFirstInChain().extractChainTo(node);
    }

    public void extractChainTo(@NotNull Node node) {
        Node lastNode = this;
        do {
            Node next = lastNode.getNext();
            node.appendChild(lastNode);
            lastNode = next;
        } while (this.getClass().isInstance(lastNode));
    }

    @NotNull
    public Node getFirstInChain() {
        Node lastNode = this;
        while (this.getClass().isInstance(lastNode.getPrevious())) {
            lastNode = lastNode.getPrevious();
        }
        return lastNode;
    }

    @Nullable
    public Node getPreviousAnyNot(Class<?> ... classes) {
        Node node = this.prev;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.prev;
            }
        }
        return node;
    }

    @Nullable
    public Node getPreviousAny(Class<?> ... classes) {
        Node node = this.prev;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.prev;
            }
        }
        return node;
    }

    @Nullable
    public Node getNextAnyNot(Class<?> ... classes) {
        Node node = this.next;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.next;
            }
        }
        return node;
    }

    @Nullable
    public Node getNextAny(Class<?> ... classes) {
        Node node = this.next;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.next;
            }
        }
        return node;
    }

    @Nullable
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Nullable
    public Node getFirstChildAnyNot(Class<?> ... classes) {
        Node node = this.firstChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.next;
            }
        }
        return node;
    }

    @Nullable
    public Node getFirstChildAny(Class<?> ... classes) {
        Node node = this.firstChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.next;
            }
        }
        return node;
    }

    @Nullable
    public Node getLastChild() {
        return this.lastChild;
    }

    @Nullable
    public Node getLastChildAnyNot(Class<?> ... classes) {
        Node node = this.lastChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) != -1) {
                node = node.prev;
            }
        }
        return node;
    }

    @Nullable
    public Node getLastChildAny(Class<?> ... classes) {
        Node node = this.lastChild;
        if (classes.length > 0) {
            while (node != null && Node.getNodeOfTypeIndex(node, classes) == -1) {
                node = node.prev;
            }
        }
        return node;
    }

    @Nullable
    public Node getParent() {
        return this.parent;
    }

    @Nullable
    public Node getGrandParent() {
        return this.parent == null ? null : this.parent.getParent();
    }

    protected void setParent(@Nullable Node parent) {
        this.parent = parent;
    }

    public void appendChild(Node child) {
        child.unlink();
        child.setParent(this);
        if (this.lastChild != null) {
            this.lastChild.next = child;
            child.prev = this.lastChild;
            this.lastChild = child;
        } else {
            this.firstChild = child;
            this.lastChild = child;
        }
    }

    public void prependChild(@NotNull Node child) {
        child.unlink();
        child.setParent(this);
        if (this.firstChild != null) {
            this.firstChild.prev = child;
            child.next = this.firstChild;
            this.firstChild = child;
        } else {
            this.firstChild = child;
            this.lastChild = child;
        }
    }

    public void unlink() {
        if (this.prev != null) {
            this.prev.next = this.next;
        } else if (this.parent != null) {
            this.parent.firstChild = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        } else if (this.parent != null) {
            this.parent.lastChild = this.prev;
        }
        this.parent = null;
        this.next = null;
        this.prev = null;
    }

    public void insertAfter(@NotNull Node sibling) {
        sibling.unlink();
        sibling.next = this.next;
        if (sibling.next != null) {
            sibling.next.prev = sibling;
        }
        sibling.prev = this;
        this.next = sibling;
        sibling.parent = this.parent;
        if (sibling.next == null) {
            assert (sibling.parent != null);
            sibling.parent.lastChild = sibling;
        }
    }

    public void insertBefore(Node sibling) {
        sibling.unlink();
        sibling.prev = this.prev;
        if (sibling.prev != null) {
            sibling.prev.next = sibling;
        }
        sibling.next = this;
        this.prev = sibling;
        sibling.parent = this.parent;
        if (sibling.prev == null) {
            assert (sibling.parent != null);
            sibling.parent.firstChild = sibling;
        }
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) + "{" + this.toStringAttributes() + "}";
    }

    public void getAstExtra(@NotNull StringBuilder out) {
    }

    public void astExtraChars(@NotNull StringBuilder out) {
        if (this.getChars().length() > 0) {
            if (this.getChars().length() <= 10) {
                Node.segmentSpanChars(out, this.getChars(), "chars");
            } else {
                Node.segmentSpanChars(out, this.getChars().getStartOffset(), this.getChars().getEndOffset(), "chars", this.getChars().subSequence(0, 5).toVisibleWhitespaceString(), SPLICE, ((BasedSequence)this.getChars().subSequence(this.getChars().length() - 5)).toVisibleWhitespaceString());
            }
        }
    }

    public static void astChars(@NotNull StringBuilder out, @NotNull CharSequence chars, @NotNull String name) {
        if (chars.length() > 0) {
            if (chars.length() <= 10) {
                out.append(' ').append(name).append(" \"").append(chars).append("\"");
            } else {
                out.append(' ').append(name).append(" \"").append(chars.subSequence(0, 5)).append(SPLICE).append(chars.subSequence(chars.length() - 5, chars.length())).append("\"");
            }
        }
    }

    @NotNull
    protected String toStringAttributes() {
        return "";
    }

    @NotNull
    public abstract BasedSequence[] getSegments();

    @NotNull
    public static BasedSequence getLeadSegment(@NotNull BasedSequence[] segments) {
        for (BasedSequence segment : segments) {
            if (segment == BasedSequence.NULL) continue;
            return segment;
        }
        return BasedSequence.NULL;
    }

    @NotNull
    public static BasedSequence getTrailSegment(BasedSequence[] segments) {
        int iMax;
        int i = iMax = segments.length;
        while (i-- > 0) {
            BasedSequence segment = segments[i];
            if (segment == BasedSequence.NULL) continue;
            return segment;
        }
        return BasedSequence.NULL;
    }

    @NotNull
    public static BasedSequence spanningChars(BasedSequence ... segments) {
        int startOffset = Integer.MAX_VALUE;
        int endOffset = -1;
        BasedSequence firstSequence = null;
        BasedSequence lastSequence = null;
        for (BasedSequence segment : segments) {
            if (segment == BasedSequence.NULL) continue;
            if (startOffset > segment.getStartOffset()) {
                startOffset = segment.getStartOffset();
                firstSequence = segment;
            }
            if (endOffset > segment.getEndOffset()) continue;
            endOffset = segment.getEndOffset();
            lastSequence = segment;
        }
        if (firstSequence != null && lastSequence != null) {
            return firstSequence.baseSubSequence(firstSequence.getStartOffset(), lastSequence.getEndOffset());
        }
        return BasedSequence.NULL;
    }

    public void setCharsFromContentOnly() {
        this.chars = BasedSequence.NULL;
        this.setCharsFromContent();
    }

    public void setCharsFromContent() {
        BasedSequence[] segments = this.getSegments();
        BasedSequence spanningChars = null;
        if (segments.length > 0) {
            BasedSequence leadSegment = Node.getLeadSegment(segments);
            BasedSequence trailSegment = Node.getTrailSegment(segments);
            if (this.firstChild == null || this.lastChild == null) {
                BasedSequence[] sequences = new BasedSequence[]{leadSegment, trailSegment};
                spanningChars = Node.spanningChars(sequences);
            } else {
                BasedSequence[] sequences = new BasedSequence[]{leadSegment, trailSegment, this.firstChild.chars, this.lastChild.chars};
                spanningChars = Node.spanningChars(sequences);
            }
        } else if (this.firstChild != null && this.lastChild != null) {
            BasedSequence[] sequences = new BasedSequence[]{this.firstChild.chars, this.lastChild.chars};
            spanningChars = Node.spanningChars(sequences);
        }
        if (spanningChars != null) {
            if (this.chars.isNull()) {
                this.setChars(spanningChars);
            } else {
                int start = Utils.min(this.chars.getStartOffset(), spanningChars.getStartOffset());
                int end = Utils.max(this.chars.getEndOffset(), spanningChars.getEndOffset());
                this.setChars(this.chars.baseSubSequence(start, end));
            }
        }
    }

    public static void segmentSpan(@NotNull StringBuilder out, int startOffset, int endOffset, @Nullable String name) {
        if (name != null && !name.trim().isEmpty()) {
            out.append(" ").append(name).append(":");
        }
        out.append("[").append(startOffset).append(", ").append(endOffset).append("]");
    }

    public static void segmentSpanChars(@NotNull StringBuilder out, int startOffset, int endOffset, @Nullable String name, @NotNull String chars) {
        Node.segmentSpanChars(out, startOffset, endOffset, name, chars, "", "");
    }

    public static void segmentSpanChars(@NotNull StringBuilder out, int startOffset, int endOffset, @Nullable String name, @NotNull String chars1, @NotNull String splice, @NotNull String chars2) {
        if (name != null && !name.trim().isEmpty()) {
            out.append(" ").append(name).append(":");
        }
        out.append("[").append(startOffset).append(", ").append(endOffset);
        if (!chars1.isEmpty() || !chars2.isEmpty()) {
            out.append(", \"");
            Utils.escapeJavaString(out, chars1);
            out.append(splice);
            Utils.escapeJavaString(out, chars2);
            out.append("\"");
        }
        out.append("]");
    }

    public static void segmentSpan(@NotNull StringBuilder out, @NotNull BasedSequence sequence, @Nullable String name) {
        if (sequence.isNotNull()) {
            Node.segmentSpan(out, sequence.getStartOffset(), sequence.getEndOffset(), name);
        }
    }

    public static void segmentSpanChars(@NotNull StringBuilder out, @NotNull BasedSequence sequence, @NotNull String name) {
        if (sequence.isNotNull()) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toString());
        }
    }

    public static void segmentSpanCharsToVisible(@NotNull StringBuilder out, @NotNull BasedSequence sequence, @NotNull String name) {
        if (sequence.isNotNull()) {
            if (sequence.length() <= 10) {
                Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toVisibleWhitespaceString());
            } else {
                Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.subSequence(0, 5).toVisibleWhitespaceString(), SPLICE, ((BasedSequence)sequence.endSequence(sequence.length() - 5)).toVisibleWhitespaceString());
            }
        }
    }

    public static void delimitedSegmentSpan(@NotNull StringBuilder out, @NotNull BasedSequence openingSequence, @NotNull BasedSequence sequence, @NotNull BasedSequence closingSequence, @NotNull String name) {
        Node.segmentSpanChars(out, openingSequence.getStartOffset(), openingSequence.getEndOffset(), name + "Open", openingSequence.toString());
        if (sequence.length() <= 10) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toVisibleWhitespaceString());
        } else {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.subSequence(0, 5).toVisibleWhitespaceString(), SPLICE, ((BasedSequence)sequence.endSequence(sequence.length() - 5)).toVisibleWhitespaceString());
        }
        Node.segmentSpanChars(out, closingSequence.getStartOffset(), closingSequence.getEndOffset(), name + "Close", closingSequence.toString());
    }

    public static void delimitedSegmentSpanChars(@NotNull StringBuilder out, @NotNull BasedSequence openingSequence, @NotNull BasedSequence sequence, @NotNull BasedSequence closingSequence, @NotNull String name) {
        if (openingSequence.isNotNull()) {
            Node.segmentSpanChars(out, openingSequence.getStartOffset(), openingSequence.getEndOffset(), name + "Open", openingSequence.toString());
        }
        if (sequence.isNotNull()) {
            Node.segmentSpanChars(out, sequence.getStartOffset(), sequence.getEndOffset(), name, sequence.toVisibleWhitespaceString());
        }
        if (closingSequence.isNotNull()) {
            Node.segmentSpanChars(out, closingSequence.getStartOffset(), closingSequence.getEndOffset(), name + "Close", closingSequence.toString());
        }
    }

    public void takeChildren(@NotNull Node node) {
        if (node.firstChild != null) {
            Node firstChild = node.firstChild;
            Node lastChild = node.lastChild;
            assert (lastChild != null);
            if (lastChild != firstChild) {
                node.firstChild = null;
                node.lastChild = null;
                firstChild.parent = this;
                lastChild.parent = this;
                if (this.lastChild != null) {
                    this.lastChild.next = firstChild;
                    firstChild.prev = this.lastChild;
                } else {
                    this.firstChild = firstChild;
                }
                this.lastChild = lastChild;
            } else {
                this.appendChild(firstChild);
            }
        }
    }

    @NotNull
    public String getNodeName() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1);
    }

    public void astString(@NotNull StringBuilder out, boolean withExtra) {
        out.append(this.getNodeName());
        out.append("[").append(this.getStartOffset()).append(", ").append(this.getEndOffset()).append("]");
        if (withExtra) {
            this.getAstExtra(out);
        }
    }

    @NotNull
    public String toAstString(boolean withExtra) {
        StringBuilder sb = new StringBuilder();
        this.astString(sb, withExtra);
        return sb.toString();
    }

    @NotNull
    public static String toSegmentSpan(@NotNull BasedSequence sequence, @Nullable String name) {
        StringBuilder out = new StringBuilder();
        Node.segmentSpan(out, sequence, name);
        return out.toString();
    }

    public BasedSequence getChildChars() {
        if (this.firstChild == null || this.lastChild == null) {
            return BasedSequence.NULL;
        }
        return this.firstChild.baseSubSequence(this.firstChild.getStartOffset(), this.lastChild.getEndOffset());
    }

    public BasedSequence getExactChildChars() {
        if (this.firstChild == null || this.lastChild == null) {
            return BasedSequence.NULL;
        }
        SequenceBuilder segments = SequenceBuilder.emptyBuilder(this.getChars());
        for (Node child = this.getFirstChild(); child != null; child = child.getNext()) {
            child.getChars().addSegments(segments.getSegmentBuilder());
        }
        return segments.toSequence();
    }

    @NotNull
    public Node getBlankLineSibling() {
        assert (this.parent != null);
        Node parent = this.parent;
        Node lastBlankLineSibling = this;
        Node nextBlankLineSibling = this;
        while (parent.parent != null) {
            boolean wasLastItem;
            boolean bl = wasLastItem = parent == parent.parent.getLastChildAnyNot(BlankLine.class);
            if (!wasLastItem) break;
            lastBlankLineSibling = nextBlankLineSibling;
            if (parent instanceof BlankLineContainer) {
                nextBlankLineSibling = parent;
            }
            if ((parent = parent.parent) != null) continue;
            break;
        }
        return lastBlankLineSibling;
    }

    public void moveTrailingBlankLines() {
        Node blankLine = this.getLastChild();
        if (blankLine instanceof BlankLine) {
            Node blankLinePos = this.getBlankLineSibling();
            blankLine = blankLine.getFirstInChain();
            blankLinePos.insertChainAfter(blankLine);
            Node parent = this;
            do {
                parent.setCharsFromContentOnly();
            } while ((parent = parent.parent) != null && parent != blankLinePos.getParent());
        }
    }

    public int getLineNumber() {
        return this.getStartLineNumber();
    }

    public int getStartLineNumber() {
        return this.getDocument().getLineNumber(this.chars.getStartOffset());
    }

    public int getEndLineNumber() {
        int endOffset = this.chars.getEndOffset();
        return this.getDocument().getLineNumber(endOffset > 0 ? endOffset - 1 : endOffset);
    }

    @NotNull
    public BasedSequence[] getSegmentsForChars() {
        return this.getSegments();
    }

    @NotNull
    public BasedSequence getCharsFromSegments() {
        @NotNull BasedSequence[] segments = this.getSegmentsForChars();
        return segments.length == 0 ? BasedSequence.NULL : SegmentedSequence.create(segments[0], Arrays.asList(segments));
    }

    public void setCharsFromSegments() {
        this.setChars(this.getCharsFromSegments());
    }

    public void appendChain(@NotNull Node firstNode) {
        Node node = firstNode;
        while (node != null) {
            Node next = node.next;
            this.appendChild(node);
            node = next;
        }
    }

    public void insertChainAfter(@NotNull Node firstNode) {
        Node posNode = this;
        Node node = firstNode;
        while (node != null) {
            Node next = node.next;
            posNode.insertAfter(node);
            posNode = node;
            node = next;
        }
    }

    public void insertChainBefore(@NotNull Node firstNode) {
        Node posNode = this;
        Node node = firstNode;
        while (node != null) {
            Node next = node.next;
            posNode.insertBefore(node);
            node = next;
        }
    }
}

